from django.shortcuts import render,redirect,get_object_or_404
from django.db.models import Sum
from datetime import date
from expence_app import forms
from expence_app import models
from django.db.models.functions import TruncMonth
from django.db.models import Sum
from datetime import date, timedelta
import calendar

def dashboard(request):
    expenses = models.Expense.objects.all().order_by('-date')
    today = date.today()

    # --- Total Expenses ---
    total = expenses.aggregate(total=Sum('amount'))['total'] or 0

    # --- This Month Total ---
    monthly_expenses = expenses.filter(date__year=today.year, date__month=today.month)
    monthly_total = monthly_expenses.aggregate(total=Sum('amount'))['total'] or 0

    # --- This Week Total ---
    start_of_week = today - timedelta(days=today.weekday())  # Monday
    weekly_expenses = expenses.filter(date__gte=start_of_week, date__lte=today)
    weekly_total = weekly_expenses.aggregate(total=Sum('amount'))['total'] or 0

    # --- Category-wise Data for Pie Chart ---
    category_data = (
        expenses.values('category__name')
        .annotate(total=Sum('amount'))
        .order_by('category__name')
    )

    # --- Monthly Data for Bar Chart ---
    monthly_data_raw = (
        expenses.annotate(month=TruncMonth('date'))
        .values('month')
        .annotate(total=Sum('amount'))
        .order_by('month')
    )

    monthly_data = []
    for entry in monthly_data_raw:
        month_name = calendar.month_name[entry['month'].month]
        monthly_data.append({
            'month_name': month_name,
            'total': entry['total']
        })

    context = {
        'expenses': expenses,
        'total': total,
        'monthly_total': monthly_total,
        'weekly_total': weekly_total,
        'category_data': category_data,
        'monthly_data': monthly_data,
    }
    return render(request, 'dashboard.html', context)



def add_expense(request):
    categories = models.Category.objects.all()
    if request.method == 'POST':
        title = request.POST['title']
        category_id = request.POST['category']
        amount = request.POST['amount']
        description = request.POST.get('description', '')
        expense_date = request.POST.get('date', date.today())

        category = models.Category.objects.get(id=category_id)
        models.Expense.objects.create(
            title=title,
            category=category,
            amount=amount,
            description=description,
            date=expense_date
        )
        return redirect(dashboard)

    return render(request, 'add_expense.html', {'categories': categories})

def update_expense(request, pk):
    expense = get_object_or_404(models.Expense, id=pk)
    categories = models.Category.objects.all()

    if request.method == 'POST':
        title = request.POST['title']
        category_id = request.POST['category']
        amount = request.POST['amount']
        description = request.POST.get('description', '')
        expense_date = request.POST.get('date', date.today())

        category = models.Category.objects.get(id=category_id)

        # Update the expense
        expense.title = title
        expense.category = category
        expense.amount = amount
        expense.description = description
        expense.date = expense_date
        expense.save()

        return redirect('dashboard')

    context = {
        'expense': expense,
        'categories': categories
    }
    return render(request,'update_expense.html', context)


def delete_expense(request, pk):
    expense = models.Expense.objects.get(id=pk)
    expense.delete()
    return redirect(dashboard)

def create_category(request):
    if request.method == 'POST':
        form = forms.categoryform(request.POST)
        if form.is_valid():
            form.save()
            return redirect(list_category)
        else:
            print(form.errors)
    return render(request, 'create_category.html')

def list_category(request):
    categories = models.Category.objects.all()
    return render(request, 'list_category.html', {'categories': categories})

def update_category(request,id):
    category = models.Category.objects.get(id=id)
    if request.method == 'POST':
        form = forms.categoryform(request.POST,instance=category)
        if form.is_valid():
            form.save()
            return redirect(list_category)
        else:
            print(form.errors)
    context = {'category': category}
    return render(request, 'update_category.html',context)

def delete_category(request, id):
    expense = models.Category.objects.get(id=id)
    expense.delete()
    return redirect(list_category)